<?php
header('Content-Type: application/json');

// CORS headers
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");

include_once __DIR__ . '/../config.php';

// Error reporting (useful for debugging)
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Connect to database
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(["success" => false, "message" => "Database connection failed"]);
    exit;
}

// Fetch suspended users
$query = "
    SELECT 
        id,
        first_name,
        last_name,
        email,
        country,
        phone,
        suspend,
        reg_date
    FROM loginusers
    WHERE suspend = 1
    ORDER BY reg_date DESC
";

$result = $conn->query($query);

if (!$result) {
    http_response_code(500);
    echo json_encode([
        "success" => false,
        "message" => "Query failed: " . $conn->error
    ]);
    exit;
}

$blocked_users = [];
while ($row = $result->fetch_assoc()) {
    $blocked_users[] = [
        "id" => $row['id'],
        "first_name" => $row['first_name'],
        "last_name" => $row['last_name'],
        "email" => $row['email'],
        "country" => $row['country'],
        "phone" => $row['phone'],
        "suspend" => (int)$row['suspend'],
        "reg_date" => $row['reg_date']
    ];
}

echo json_encode([
    "success" => true,
    "count" => count($blocked_users),
    "blocked_users" => $blocked_users
]);

$conn->close();
?>
