<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

include_once __DIR__ . "/../config.php";

try {
    if (!isset($_GET['tradeid'])) {
        throw new Exception("Missing tradeid parameter");
    }

    $tradeid = $_GET['tradeid'];
    $status = 3; // cancel

    $sql = "UPDATE liveaccounts SET masteracc=? WHERE trade_id=?";
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        throw new Exception($conn->error);
    }

    $stmt->bind_param("is", $status, $tradeid);
    if ($stmt->execute()) {
        echo json_encode(["status" => "success", "message" => "Master account cancelled successfully"]);
    } else {
        throw new Exception($stmt->error);
    }

} catch (Exception $e) {
    echo json_encode([
        "status" => "error",
        "message" => $e->getMessage()
    ]);
}
?>
