<?php
header('Content-Type: application/json');
include_once __DIR__ . "/../config.php";

try {
    // Fetch only pending requests (admin needs to approve/reject these)
    $query = "SELECT id, email, mastername, mastertrade, slavename, slavetrade, status, created_at 
              FROM copyaccounts 
              WHERE status = 'pending' 
              ORDER BY id DESC";
              
    $result = mysqli_query($conn, $query);

    if (!$result) {
        echo json_encode([
            "status" => "error",
            "message" => "Query failed: " . mysqli_error($conn)
        ]);
        exit;
    }

    $data = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $data[] = $row;
    }

    if (empty($data)) {
        echo json_encode([
            "status" => "success",
            "message" => "No pending requests found",
            "data" => []
        ]);
    } else {
        echo json_encode([
            "status" => "success",
            "message" => "Pending requests fetched successfully",
            "data" => $data
        ]);
    }
} catch (Exception $e) {
    echo json_encode([
        "status" => "error",
        "message" => "Something went wrong: " . $e->getMessage()
    ]);
}
?>
