<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
include_once __DIR__ . "/../config.php";

try {
    $stmt = $conn->prepare("SELECT days_threshold, commission_percent FROM deposit_unused_commission_settings LIMIT 1");
    $stmt->execute();
    $res = $stmt->get_result();
    $settings = $res->fetch_assoc() ?: ["days_threshold" => 45, "commission_percent" => 1.00];
    $stmt->close();

    echo json_encode(["success" => true, "settings" => $settings]);
} catch (Throwable $e) {
    error_log("admin_fetch_deposit_unused_com error: " . $e->getMessage());
    echo json_encode(["success" => false, "message" => "Server error"]);
}
