<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Access-Control-Allow-Methods: POST");

// Load DB connection
include __DIR__ . "/../config.php";

$data = json_decode(file_get_contents("php://input"), true);

$child_email = $data["child_email"] ?? null;
$new_ib_email = $data["new_ib_email"] ?? null;

if (!$child_email || !$new_ib_email) {
    echo json_encode(["success" => false, "message" => "child_email and new_ib_email are required"]);
    exit;
}

/* -------------------------------------------------------
    STEP 1 — FETCH NEW IB HIERARCHY
------------------------------------------------------- */
$ibQuery = $conn->prepare("
    SELECT 
        ib1, ib2, ib3, ib4, ib5, ib6, ib7, ib8, ib9, ib10,
        ib11, ib12, ib13, ib14, ib15, ib16, ib17, ib18, ib19, ib20,
        level
    FROM loginusers
    WHERE email = ?
    LIMIT 1
");
$ibQuery->bind_param("s", $new_ib_email);
$ibQuery->execute();
$ibResult = $ibQuery->get_result()->fetch_assoc();

if (!$ibResult) {
    echo json_encode(["success" => false, "message" => "New IB not found"]);
    exit;
}

/* -------------------------------------------------------
    STEP 2 — RESET CHILD'S OLD IB CHAIN
------------------------------------------------------- */
$resetSql = "
    UPDATE loginusers SET 
        ib1='noIB', ib2='noIB', ib3='noIB', ib4='noIB', ib5='noIB',
        ib6='noIB', ib7='noIB', ib8='noIB', ib9='noIB', ib10='noIB',
        ib11='noIB', ib12='noIB', ib13='noIB', ib14='noIB', ib15='noIB',
        ib16='noIB', ib17='noIB', ib18='noIB', ib19='noIB', ib20='noIB',
        level = 0
    WHERE email = ?
";
$stmt = $conn->prepare($resetSql);
$stmt->bind_param("s", $child_email);
$stmt->execute();

/* -------------------------------------------------------
    STEP 3 — APPLY NEW IB HIERARCHY
------------------------------------------------------- */
$newLevel = intval($ibResult["level"]) + 1;

$updateSql = "
    UPDATE loginusers SET 
        ib1=?, ib2=?, ib3=?, ib4=?, ib5=?, 
        ib6=?, ib7=?, ib8=?, ib9=?, ib10=?,
        ib11=?, ib12=?, ib13=?, ib14=?, ib15=?,
        ib16=?, ib17=?, ib18=?, ib19=?, ib20=?,
        level=?
    WHERE email=?
";

$stmt2 = $conn->prepare($updateSql);
$stmt2->bind_param(
    "sssssssssssssssssssis",
    $new_ib_email,
    $ibResult["ib1"], $ibResult["ib2"], $ibResult["ib3"], $ibResult["ib4"], $ibResult["ib5"],
    $ibResult["ib6"], $ibResult["ib7"], $ibResult["ib8"], $ibResult["ib9"], $ibResult["ib10"],
    $ibResult["ib11"], $ibResult["ib12"], $ibResult["ib13"], $ibResult["ib14"], $ibResult["ib15"],
    $ibResult["ib16"], $ibResult["ib17"], $ibResult["ib18"], $ibResult["ib19"], $ibResult["ib20"],
    $newLevel,
    $child_email
);
$stmt2->execute();

/* -------------------------------------------------------
    STEP 4 — UPDATE LIVEACCOUNTS ALSO
------------------------------------------------------- */
$updateLive = "
    UPDATE liveaccounts SET 
        ib1=?, ib2=?, ib3=?, ib4=?, ib5=?, 
        ib6=?, ib7=?, ib8=?, ib9=?, ib10=?,
        ib11=?, ib12=?, ib13=?, ib14=?, ib15=?,
        ib16=?, ib17=?, ib18=?, ib19=?, ib20=?
    WHERE email = ?
";

$stmt3 = $conn->prepare($updateLive);
$stmt3->bind_param(
    "ssssssssssssssssssss",
    $new_ib_email,
    $ibResult["ib1"], $ibResult["ib2"], $ibResult["ib3"], $ibResult["ib4"], $ibResult["ib5"],
    $ibResult["ib6"], $ibResult["ib7"], $ibResult["ib8"], $ibResult["ib9"], $ibResult["ib10"],
    $ibResult["ib11"], $ibResult["ib12"], $ibResult["ib13"], $ibResult["ib14"], $ibResult["ib15"],
    $ibResult["ib16"], $ibResult["ib17"], $ibResult["ib18"], $ibResult["ib19"], $ibResult["ib20"],
    $child_email
);
$stmt3->execute();

/* -------------------------------------------------------
    SUCCESS RESPONSE
------------------------------------------------------- */
echo json_encode([
    "success" => true,
    "message" => "IB updated successfully",
    "new_level" => $newLevel
]);
?>
