<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
include_once __DIR__ . "/../config.php";

try {
    $stmt = $conn->prepare("
        SELECT l.*, lu.email
        FROM unused_deposit_commission_log l
        LEFT JOIN loginusers lu ON lu.id = l.user_id
        ORDER BY l.credited_at DESC
        LIMIT 500
    ");
    $stmt->execute();
    $res = $stmt->get_result();
    $logs = [];
    while ($row = $res->fetch_assoc()) $logs[] = $row;
    $stmt->close();

    echo json_encode(["success" => true, "logs" => $logs]);
} catch (Throwable $e) {
    error_log("admin_view_unused_commission_log error: " . $e->getMessage());
    echo json_encode(["success" => false, "message" => "Server error"]);
}
