<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

include_once __DIR__ . '/config.php'; 

$trade_id = $_GET['trade_id'] ?? '';

if (!$trade_id) {
    echo json_encode(["success" => false, "error" => "Trade ID required"]);
    exit;
}

$stmt = $conn->prepare("SELECT id FROM kycupload WHERE trade_id = ? LIMIT 1");
$stmt->bind_param("s", $trade_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    echo json_encode(["success" => true, "hasKyc" => true]);
} else {
    echo json_encode(["success" => true, "hasKyc" => false]);
}

$stmt->close();
$conn->close();
